<?php

if ( empty( $listings_number ) ) {
	$listings_number = 8;
}

$listing_types = array( apply_filters( 'stm_listings_post_type', 'listings' ) );

if ( function_exists( 'stm_listings_multi_type' ) ) {
	$listing_types = stm_listings_multi_type( true );
}

$uniqid                  = uniqid();
$tab_activity_class      = 'active';
$tab_pane_activity_class = 'in active';
$ajax_img_args           = '';
$grid_title_max_length   = ! empty( $grid_title_max_length ) ? intval( $grid_title_max_length ) : '';

if ( ! empty( $grid_thumb_img_size ) && ( in_array( $grid_thumb_img_size, get_intermediate_image_sizes() ) || 'full' === $grid_thumb_img_size ) ) {
	$ajax_img_args = $grid_thumb_img_size;
}
?>

<div class="stm_elementor_multi_listings_grid_tabs_wrap stm_listing_tabs_style_2">

	<div class="clearfix">

		<?php if ( ! empty( $grid_title ) ) : ?>
			<h3 class="hidden-md hidden-lg hidden-sm"><?php echo wp_kses_post( $grid_title ); ?></h3>
		<?php endif; ?>

		<?php
		$tabs_total = ( isset( $tabs ) && is_array( $tabs ) && ! empty( $tabs ) ) ? count( $tabs ) : 0;

		if ( 'yes' === $include_popular ) {
			$tabs_total ++;
		}
		if ( 'yes' === $include_recent ) {
			$tabs_total ++;
		}
		if ( 'yes' === $include_featured ) {
			$tabs_total ++;
		}

		if ( $tabs_total > 1 ) :
			?>

			<!-- Nav tabs -->
			<ul class="stm_listing_nav_list heading-font" role="tablist">

				<?php if ( ! empty( $tabs ) ) : ?>

					<?php foreach ( $tabs as $index => $tab ) : ?>
						<li role="presentation" class="<?php echo esc_attr( $tab_activity_class ); ?>">
							<a href="#listing-type-<?php echo esc_attr( $tab['listing_type'] . '-' . $uniqid . '-' . $index ); ?>"
								role="tab"
								data-toggle="tab">
								<span><?php echo esc_html( $tab['tab_title'] ); ?></span>
							</a>
						</li>
						<?php $tab_activity_class = ''; ?>
					<?php endforeach; ?>

				<?php endif; ?>

				<?php if ( ! empty( $include_popular ) && 'yes' === $include_popular ) : ?>
					<li role="presentation" class="<?php echo esc_attr( $tab_activity_class ); ?>">
						<a href="#popular-<?php echo esc_attr( $uniqid ); ?>" aria-controls="popular" role="tab"
							data-toggle="tab"><span><?php echo esc_attr( $popular_label ); ?></span></a>
					</li>
					<?php $tab_activity_class = ''; ?>
				<?php endif; ?>

				<?php if ( ! empty( $include_recent ) && 'yes' === $include_recent ) : ?>
					<li role="presentation" class="<?php echo esc_attr( $tab_activity_class ); ?>">
						<a href="#recent-<?php echo esc_attr( $uniqid ); ?>" aria-controls="recent" role="tab"
							data-toggle="tab"><span><?php echo esc_attr( $recent_label ); ?></span></a>
					</li>
					<?php $tab_activity_class = ''; ?>
				<?php endif; ?>

				<?php if ( ! empty( $include_featured ) && 'yes' === $include_featured ) : ?>
					<li role="presentation" class="<?php echo esc_attr( $tab_activity_class ); ?>">
						<a href="#featured-<?php echo esc_attr( $uniqid ); ?>" aria-controls="recent" role="tab"
							data-toggle="tab"><span><?php echo esc_attr( $featured_label ); ?></span></a>
					</li>
					<?php $tab_activity_class = ''; ?>
				<?php endif; ?>

			</ul>

		<?php endif; ?>

		<?php if ( ! empty( $grid_title ) ) : ?>
			<h3 class="hidden-xs"><?php echo wp_kses_post( $grid_title ); ?></h3>
		<?php endif; ?>

	</div>

	<!-- Tab panes -->
	<div class="tab-content">
		<?php
		$per_row  = ( $listings_number_per_row ) ? $listings_number_per_row : 4;
		$template = 'partials/listing-cars/listing-grid-directory-loop-' . $per_row;

		if ( apply_filters( 'stm_is_motorcycle', false ) ) {
			$per_row  = 3;
			$template = 'partials/listing-cars/motos/moto-single-grid';
		}

		if ( ! empty( $tabs ) ) :
			foreach ( $tabs as $index => $tab ) :
				$tab_pane_id   = 'listing-type-' . $tab['listing_type'] . '-' . $uniqid . '-' . $index;
				$listing_type  = $tab['listing_type'];
				$order_by      = $tab['items_order_by'];
				$show_all_link = $tab['show_all_link'];
				$show_all_text = $tab['show_all_link_text'];
				?>
				<div role="tabpanel" class="tab-pane fade <?php echo esc_attr( $tab_pane_activity_class ); ?>"
					id="<?php echo esc_attr( $tab_pane_id ); ?>"></div>
				<script>
					(function ($) {
						$(document).ready(function () {
							$.ajax({
								type: "POST",
								url: ajaxurl,
								dataType: 'json',
								async: true,
								data: 'action=ml_grid_tabs' +
									'&listing_type=<?php echo esc_js( $listing_type ); ?>' +
									'&order_by=<?php echo esc_js( $order_by ); ?>' +
									'&show_all_link=<?php echo esc_js( $show_all_link ); ?>' +
									'&show_all_text=<?php echo esc_js( $show_all_text ); ?>' +
									'&per_page=<?php echo esc_js( $per_row ); ?>' +
									'&template=<?php echo esc_js( $template ); ?>' +
									'&img_size=<?php echo esc_js( $ajax_img_args ); ?>' +
									'&title_max_length=<?php echo esc_js( $grid_title_max_length ); ?>' +
									'&security=' + mew_nonces.motors_ml_grid_tabs,
								success: function (data) {
									if (data.hasOwnProperty('html')) $('#<?php echo esc_js( $tab_pane_id ); ?>').html(data.html);
									updateGridItemTitles();
								},
							});
						});
					})(jQuery)
				</script>
				<?php
				$tab_pane_activity_class = '';
			endforeach;
		endif;
		?>

		<?php if ( ! empty( $include_popular ) && 'yes' === $include_popular ) : ?>
			<div role="tabpanel"
				class="tab-pane fade <?php echo esc_attr( $tab_pane_activity_class ); ?>"
				id="popular-<?php echo esc_attr( $uniqid ); ?>">
				<script>
					(function ($) {
						$(document).ready(function () {
							$.ajax({
								type: "POST",
								url: ajaxurl,
								dataType: 'json',
								async: true,
								data: 'action=ml_grid_tabs' +
									'&listing_types=<?php echo esc_js( implode( ',', $listing_types ) ); ?>' +
									'&tab_type=popular' +
									'&per_page=<?php echo esc_js( $per_row ); ?>' +
									'&template=<?php echo esc_js( $template ); ?>' +
									'&img_size=<?php echo esc_js( $ajax_img_args ); ?>' +
									'&title_max_length=<?php echo esc_js( $grid_title_max_length ); ?>' +
									'&security=' + mew_nonces.motors_ml_grid_tabs,
								success: function (data) {
									if (data.hasOwnProperty('html')) $('#popular-<?php echo esc_attr( $uniqid ); ?>').html(data.html);
									updateGridItemTitles();
								},
							});
						});
					})(jQuery)
				</script>
			</div>
			<?php
			$tab_pane_activity_class = '';
		endif;
		?>

		<?php if ( ! empty( $include_recent ) && 'yes' === $include_recent ) : ?>
			<div role="tabpanel"
				class="tab-pane fade <?php echo esc_attr( $tab_pane_activity_class ); ?>"
				id="recent-<?php echo esc_attr( $uniqid ); ?>">
				<script>
					(function ($) {
						$(document).ready(function () {
							$.ajax({
								type: "POST",
								url: ajaxurl,
								dataType: 'json',
								async: true,
								data: 'action=ml_grid_tabs' +
									'&listing_types=<?php echo esc_js( implode( ',', $listing_types ) ); ?>' +
									'&tab_type=recent' +
									'&per_page=<?php echo esc_js( $per_row ); ?>' +
									'&template=<?php echo esc_js( $template ); ?>' +
									'&img_size=<?php echo esc_js( $ajax_img_args ); ?>' +
									'&title_max_length=<?php echo esc_js( $grid_title_max_length ); ?>' +
									'&security=' + mew_nonces.motors_ml_grid_tabs,
								success: function (data) {
									if (data.hasOwnProperty('html')) $('#recent-<?php echo esc_attr( $uniqid ); ?>').html(data.html);
									updateGridItemTitles();
								},
							});
						});
					})(jQuery)
				</script>
			</div>
			<?php
			$tab_pane_activity_class = '';
		endif;
		?>

		<?php if ( ! empty( $include_featured ) && 'yes' === $include_featured ) : ?>
			<div role="tabpanel" class="tab-pane fade <?php echo esc_attr( $tab_pane_activity_class ); ?>"
				id="featured-<?php echo esc_attr( $uniqid ); ?>">
				<script>
					(function ($) {
						$(document).ready(function () {
							$.ajax({
								type: "POST",
								url: ajaxurl,
								dataType: 'json',
								async: true,
								data: 'action=ml_grid_tabs' +
									'&listing_types=<?php echo esc_js( implode( ',', $listing_types ) ); ?>' +
									'&tab_type=featured' +
									'&per_page=<?php echo esc_js( $per_row ); ?>' +
									'&template=<?php echo esc_js( $template ); ?>' +
									'&img_size=<?php echo esc_js( $ajax_img_args ); ?>' +
									'&title_max_length=<?php echo esc_js( $grid_title_max_length ); ?>' +
									'&security=' + mew_nonces.motors_ml_grid_tabs,
								success: function (data) {
									if (data.hasOwnProperty('html')) $('#featured-<?php echo esc_attr( $uniqid ); ?>').html(data.html);
									updateGridItemTitles();
								},
							});
						});
					})(jQuery)
				</script>
			</div>
			<?php
			$tab_pane_activity_class = '';
		endif;
		?>
	</div>
</div>
